require "behaviours/wander"
require "behaviours/faceentity"
require "behaviours/chaseandattack"
require "behaviours/panic"
require "behaviours/follow"
require "behaviours/chattynode"
require "behaviours/attackwall"
require "behaviours/standstill"

local clearskyaiBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local MIN_FOLLOW_DIST = 0
local TARGET_FOLLOW_DIST = 4
local MAX_FOLLOW_DIST = 6

local START_FACE_DIST = 6
local KEEP_FACE_DIST = 8

local KEEP_WORKING_DIST = 15
local SEE_WORK_DIST = 15

local RUN_AWAY_DIST = 5
local STOP_RUN_AWAY_DIST = 8

local RUN_AWAY_EPIC = 5
local RUN_AWAY_EPIC_STOP = 10 


local STOP_RUN_DIST = 8
local MAX_CHASE_TIME = 10
local MAX_WANDER_DIST = 4

local MAX_CHASE_DIST = 15
local TRADE_DIST = 20
local SEE_TREE_DIST = 15
local SEE_TARGET_DIST = 20


local AVOID_EXPLOSIVE_DIST = 5

local LEASH_RETURN_DIST = 7
local LEASH_MAX_DIST = 7

local DIG_TAGS = { "stump", "grave" }

local CLEARSKYAI_TALK_MINE = {"Manual labor sucks even if you have help.", "We need the suit repairs.", "The more cover we have the better chance of surviving."}
local CLEARSKYAI_TALK_CHOP = {"Fire wood, can never get enough of it.", "Manual labor sucks even if you have help.", "Hope a treeguard doesn't come."}
local CLEARSKYAI_TALK_ATTACK = {"Your going down!", "Lets give them hell!","This won't end well for you!"}
local CLEARSKYAI_TALK_EXPLOSIVE = {"Explosives armed!", "Get out of the blast radius!", "Don't stand there! Move!"}
local CLEARSKYAI_TALK_DIG = {"On it.", "Got it bro.", "If you say so."}
local CLEARSKYAI_TALK_HAMMER = {"Got it bro.", "On it.", "Got some decorating ideas?"}
local DUTYEXOAI_TALK_HIDE = {"Hiding!", "Out of sight."}
local CLEARSKYAI_TALK_HACK = {"On it bro.", "Manual labor sucks even if you have help.", "Watch for snakes."}

local function GetTraderFn(inst)
    local x, y, z = inst.Transform:GetWorldPosition()
    local players = FindPlayersInRange(x, y, z, TRADE_DIST, true)
    for i, v in ipairs(players) do
        if inst.components.trader:IsTryingToTradeWithMe(v) then
            return v
        end
    end
end

local function KeepTraderFn(inst, target)
    return inst.components.trader:IsTryingToTradeWithMe(target)
end

local function GetLeader(inst)
    return inst.components.follower.leader
end


local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
   return inst.components.follower.leader == target
end

local function GetWanderPosition(inst)
	if inst.components.follower and inst.components.follower.leader then
		return Point(inst.components.follower.leader.Transform:GetWorldPosition())
	end
end

local function HasStateTags(inst, tags)
    for i, v in ipairs(tags) do
        if inst.sg:HasStateTag(v) then
            return true
        end
    end
end

local function KeepWorkingAction(inst, actiontags)
    return inst.components.follower.leader ~= nil
        and inst.components.follower.leader:IsNear(inst, KEEP_WORKING_DIST)
        and HasStateTags(inst.components.follower.leader, actiontags)
end

local function StartWorkingCondition(inst, actiontags)
    return inst.components.follower.leader ~= nil
        and HasStateTags(inst.components.follower.leader, actiontags)
        and not HasStateTags(inst, actiontags)
end

local function FindObjectToWorkAction(inst, action)
    if inst.sg:HasStateTag("working") then
        return
    end
    local target = FindEntity(inst.components.follower.leader, SEE_WORK_DIST, function(item) return item.components.workable and item.components.workable.action == action end)
    return target ~= nil
        and BufferedAction(inst, target, action)
        or nil
end

local function GetLeader(inst)
    return inst.components.follower.leader
end

local function GetFaceTargetFn(inst)
    local target = GetClosestInstWithTag("player", inst, START_FACE_DIST)
    return target ~= nil and not target:HasTag("notarget") and target or nil
end

local function KeepFaceTargetFn(inst, target)
    return not target:HasTag("notarget") and inst:IsNear(target, KEEP_FACE_DIST)
end

-- local function ShouldAvoidExplosive(target)
    -- return target.components.explosive == nil
        -- or target.components.burnable == nil
        -- or target.components.burnable:IsBurning()
-- end

local function ShouldRunAwayEasy(inst)
    return FindEntity(inst, RUN_AWAY_DIST, nil, nil, {"bearded", "duty", "loner", "mithrarin", "truce", "boomerangbuilder", "dismantler", "fireblooded", "clearsky", "freedom"}, {"monster", "hostile", "monolith", "USS", "bandit", "frog"})
end



local function hide(inst)
    inst:PushEvent("hide")
end




local function StartDiggingCondition(inst)
    return  (inst.components.follower.leader ~= nil and
            inst.components.follower.leader.sg ~= nil and
            inst.components.follower.leader.sg:HasStateTag("digging"))
end

local function FindDigAction(inst, action)
    local target = FindEntity(inst, KEEP_WORKING_DIST, nil, { "DIG_workable" }, { "cattoy", "INLIMBO", "witherable" })
		return target ~= nil
        and BufferedAction(inst, target, ACTIONS.DIG)
		or nil
    end


function clearskyaiBrain:OnStart()
    local root = PriorityNode(
    {
        RunAway(self.inst, "epic", RUN_AWAY_EPIC, RUN_AWAY_EPIC_STOP),
		
		ChattyNode(self.inst,CLEARSKYAI_TALK_ATTACK,
				ChaseAndAttack(self.inst, 5)),	
		
		RunAway(self.inst, ShouldRunAwayEasy, RUN_AWAY_DIST, STOP_RUN_AWAY_DIST),
		
		--RunAway(self.inst, { fn = ShouldRunAway, oneoftags = { "monster", "hostile", "monolith", "USS", "bandit", "lava"}, notags = { "INLIMBO", "truce" } }, RUN_AWAY_DIST, STOP_RUN_AWAY_DIST),
	
		ChattyNode(self.inst, DUTYEXOAI_TALK_HIDE,
			WhileNode( function() return GetLeader(self.inst) and GetLeader(self.inst).sg and GetLeader(self.inst).sg:HasStateTag("hiding") end, "hide",
				DoAction(self.inst, hide, "hide", false) )),
	
        WhileNode(function()
                return StartWorkingCondition(self.inst, { "chopping", "prechop" })
                    and KeepWorkingAction(self.inst, { "chopping", "prechop" })
            end,
            "keep chopping",
            ChattyNode(self.inst,CLEARSKYAI_TALK_CHOP,DoAction(self.inst, function() return FindObjectToWorkAction(self.inst, ACTIONS.CHOP) end))),

        WhileNode(function()
                return StartWorkingCondition(self.inst, { "mining", "premine" })
                    and KeepWorkingAction(self.inst, { "mining", "premine" })
            end,
            "keep mining",
            ChattyNode(self.inst,CLEARSKYAI_TALK_MINE,DoAction(self.inst, function() return FindObjectToWorkAction(self.inst, ACTIONS.MINE) end))),
			
			WhileNode(function()
				return StartWorkingCondition(self.inst, { "prehammer", "hammering" })
					and KeepWorkingAction(self.inst, { "prehammer", "hammering" })
			end,
			"keep hammering",
			ChattyNode(self.inst, CLEARSKYAI_TALK_HAMMER, DoAction(self.inst, function() return FindObjectToWorkAction(self.inst, ACTIONS.HAMMER) end))),

				
				WhileNode(function()
				return StartDiggingCondition(self.inst, { "digging", "predig" }) 
				and KeepWorkingAction(self.inst, { "digging", "predig" }) 
				end,
				"keep digging",
				ChattyNode(self.inst, CLEARSKYAI_TALK_DIG, DoAction(self.inst, function() return FindDigAction(self.inst, ACTIONS.DIG, DIG_TAGS) end))),
			

		Follow(self.inst, GetLeader, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
		FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn),
		Wander(self.inst, GetWanderPosition, MAX_WANDER_DIST)
    }, .25)

    self.bt = BT(self.inst, root)
end


return clearskyaiBrain
